#ifndef _MONITOR_CPP
#define _MONITOR_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <Stdio.H>
#include <Stdlib.H>
#include <CommCtrl.H>

#include "../Resources/Resource.H"
#include "../../SharedClasses/Graph/Graph.H"

#include "../Source/NSWFL.H"
#include "../Source/Entry.H"
#include "../Source/Routines.H"
#include "../Source/Console.H"

#include "../Dialogs/MainDlg.H"
#include "../Dialogs/Monitor.H"

#include "../Dialogs/TabClientDBS.H"
#include "../Dialogs/TabGeneral.H"
#include "../Dialogs/TabSecurity.H"
#include "../Dialogs/TabServer.H"
#include "../Dialogs/TabWPIndex.H"

#include "../SockServer/SockServer.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//---------------------(Variable Declarations)
HWND MonitorDialog_hWnd = NULL;

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK MonitorDialog(HWND xHandle, UINT xMessage, WPARAM wParam, LPARAM lParam)
{
    //--------------------------------------------------------------------------

	static HMENU SystemMenu = NULL;

    //--------------------------------------------------------------------------

    if(xMessage == WM_INITDIALOG) // Received A Initilize Dialog Message
    {
        MonitorDialog_hWnd = xHandle;

        SystemMenu = GetSystemMenu(xHandle, FALSE);
        AppendMenu(SystemMenu, MF_SEPARATOR, 0, 0);
        AppendMenu(SystemMenu, MF_STRING, 1000, "About");

        SendMessage(xHandle, (UINT)WM_SETTEXT, (WPARAM)0, (LPARAM)gsTitleCaption);
        SendMessage(xHandle, WM_SETICON, TRUE, (LPARAM) LoadIcon(ghAppInstance, MAKEINTRESOURCE(IDI_MAIN)) );

        MONDI.UsageGraph_hWnd = GetDlgItem(xHandle, IDC_USAGEGRAPH);

		RECT WindowRECT;
        GetClientRect(xHandle, &WindowRECT);
        MoveWindow(MONDI.UsageGraph_hWnd, 0, 0, WindowRECT.right, WindowRECT.bottom, TRUE);

        InitGraph(MONDI.UsageGraph_hWnd, RGB(255,0,0), RGB(50,100,100), 3, GRAPH_LEFT);

		SetTimer(xHandle, 0, 25, NULL);

		CenterWindow(xHandle);

		return TRUE; // Return TRUE to set the keyboard focus, Otherwise return FALSE
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_COMMAND)
    {

        return FALSE;
    }

	//--------------------------------------------------------------------------

	if(xMessage == WM_TIMER)
    {
		UpdateGraph(MONDI.UsageGraph_hWnd, gServer.GetCurrentClients(), giMaxClients);
		DrawGraph(MONDI.UsageGraph_hWnd, RGB(0,0,0));
		return true;
    }

	//--------------------------------------------------------------------------

	if(xMessage == WM_SIZE)
    {
        int nWidth = LOWORD(lParam);
        int nHeight = HIWORD(lParam);
        MoveWindow(MONDI.UsageGraph_hWnd, 0, 0, nWidth, nHeight, TRUE);

		CloseGraph(MONDI.UsageGraph_hWnd);
		InitGraph(MONDI.UsageGraph_hWnd, RGB(255,0,0), RGB(50,100,100), 2, GRAPH_LEFT);

		return TRUE;
    }

	//--------------------------------------------------------------------------

	if(xMessage == WM_PAINT)
    {
        HDC ThisHDC;
        PAINTSTRUCT ThisPS;

        ThisHDC = BeginPaint(xHandle, &ThisPS);

        // Any painting should be done here

        EndPaint(xHandle, &ThisPS);
        return TRUE;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_SYSCOMMAND) // Received A System Menu Message
    {
        if(LOWORD(wParam) == 1000) //- About (SysMenu Command)
        {
            _AboutDialogInfo ADI;
    
            ADI.DisplayIcon  = LoadIcon(ghAppInstance, MAKEINTRESOURCE(IDI_MAIN));
            ADI.TitleCaption = gsTitleCaption;
            ADI.FileVersion  = gsFileVersion;
            ADI.BuildDate    = __DATE__;
            ADI.BuildTime    = __TIME__;
            ADI.CopyRight    = gsAppCopyRight;
            ADI.OwnerHandle  = xHandle;

            NetLogo(&ADI);
            return TRUE;
        }

        return FALSE;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_CLOSE)  // Received Close Message
    {
        gbIsMonitorDialogOpen = false;
	    KillTimer(xHandle, 0);
		CloseGraph(MONDI.UsageGraph_hWnd);
		EndDialog(xHandle,0);
        return TRUE;
    }

    //--------------------------------------------------------------------------

    return FALSE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
